import { NextRequest, NextResponse } from 'next/server';
import { productStore, initializeDefaultData } from '@/lib/data-store';

export async function GET() {
  try {
    await initializeDefaultData();
    const products = await productStore.getAll();
    return NextResponse.json({ success: true, data: products });
  } catch (error) {
    return NextResponse.json({ success: false, error: 'Failed to fetch products' }, { status: 500 });
  }
}

export async function POST(request: NextRequest) {
  try {
    const data = await request.json();
    const product = await productStore.create(data);
    return NextResponse.json({ success: true, data: product });
  } catch (error) {
    return NextResponse.json({ success: false, error: 'Failed to create product' }, { status: 500 });
  }
}